/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.plan;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.plan.Activity;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceActivityVisitor;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.CumulativeAction;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.store.InPlanPtnStoreActivity;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.store.StoreActivityFactory;
import cz.insophy.inplan.store.StoreActivityOwner;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.superplan.ProductionTreeNode;
import cz.insophy.inplan.superplan.ProductionTreeVisitor;
import cz.insophy.inplan.superplan.Superplan;
import java.util.List;

public class ActionActivity
extends WorkplaceActivity
implements ProductionTreeNode,
StoreActivityOwner {
    private Action action;
    private double qty;
    private List<InPlanPtnStoreActivity> storeActivities;
    private ProductionTreeNode parent;

    public ActionActivity(long start, long end, Workplace workplace, Action action, double qty) {
        super(start, end, workplace);
        this.setQty(qty);
        this.setAction(action);
    }

    public ActionActivity(ActionActivity other) {
        super(other.getStart(), other.getEnd(), other.getWorkplace());
        this.setQty(other.qty);
        this.setAction(other.action);
    }

    private void createStoreActivities() {
        if (this.action != null) {
            this.storeActivities = StoreActivityFactory.createStoreActivities(this);
        }
    }

    public void setAction(Action action) {
        if (this.action != null) {
            throw new IllegalStateException("ActionActivity's action has been already set.");
        }
        if (action == null) {
            return;
        }
        Preconditions.checkState(this.getWorkplace() == null || this.getWorkplace().getRebuildType(action.getRebuildType()) != null, "%s is incompatible with %s", (Object)action.getRebuildType(), (Object)this.getWorkplace());
        this.action = action;
        this.createStoreActivities();
    }

    public Action getAction() {
        if (this.action == null) {
            throw new IllegalStateException("ActionActivity does not have its action set yet.");
        }
        return this.action;
    }

    public double getQty() {
        return this.qty;
    }

    public void setQty(double newQty) {
        if (newQty == 0.0) {
            throw new IllegalArgumentException("Action activity's quantity must not be 0.");
        }
        if (newQty != this.qty) {
            this.unsafeSetQty(newQty);
            if (this.parent != null) {
                this.parent.childChanged(this);
            }
        }
    }

    public void unsafeSetQty(double newQty) {
        this.qty = newQty;
        this.changeStoreActivities();
        this.notifyGar();
    }

    @Override
    public void setStart(long start) {
        if (this.action instanceof CumulativeAction) {
            throw new IllegalStateException("Cannot use setStart on CumulativeAction. Move the enclosing CWA instead.");
        }
        if (start != this.getStart()) {
            this.unsafeSetStart(start);
            if (this.parent != null) {
                this.parent.childChanged(this);
            }
        }
    }

    public void unsafeSetStart(long start) {
        super.setStart(start);
        this.changeStoreActivities();
        this.notifyGar();
    }

    @Override
    public void setEnd(long end) {
        if (this.action instanceof CumulativeAction) {
            throw new IllegalStateException("Cannot use setEnd on CumulativeAction. Move the enclosing CWA instead.");
        }
        if (end != this.getEnd()) {
            this.unsafeSetEnd(end);
            if (this.parent != null) {
                this.parent.childChanged(this);
            }
        }
    }

    public void unsafeSetEnd(long end) {
        super.setEnd(end);
        this.changeStoreActivities();
        this.notifyGar();
    }

    @Override
    public void setStartEnd(long start, long end) {
        if (this.action instanceof CumulativeAction) {
            throw new IllegalStateException("Cannot use setStartEnd on CumulativeAction. Move the enclosing CWA instead.");
        }
        this.unsafeSetStartEnd(start, end);
        if (this.parent != null) {
            this.parent.childChanged(this);
        }
    }

    protected void setStartEndFromCwa(long start, long end) {
        this.unsafeSetStartEnd(start, end);
        if (this.parent != null) {
            this.parent.childChanged(this);
        }
    }

    public void unsafeSetStartEnd(long start, long end) {
        super.setStartEnd(start, end);
        this.changeStoreActivities();
        this.notifyGar();
    }

    private void notifyGar() {
        if (this.getGar() != null) {
            this.getGar().notifyAaChanged();
        }
    }

    private void changeStoreActivities() {
        if (this.storeActivities == null) {
            return;
        }
        this.removeStoreActivitiesFromPlan();
        this.storeActivities.clear();
        this.createStoreActivities();
        this.addStoreActivitiesToPlan();
    }

    public List<InPlanPtnStoreActivity> getStoreActivities() {
        return this.storeActivities;
    }

    @Override
    public Activity duplicate() {
        return new ActionActivity(this);
    }

    @Override
    public void unsafeSetParent(ProductionTreeNode parent) {
        this.parent = parent;
        if (parent == null) {
            return;
        }
        GeneralizedActionRequest gar = (GeneralizedActionRequest)parent;
        if (gar.getAction() != this.action) {
            throw new IllegalArgumentException("Action activity cannot be added to a GAR with different action.");
        }
        if (this.getPlan() == null) {
            this.setPlan(gar.getPlan());
        } else if (gar.getPlan() != null && this.getPlan() != gar.getPlan()) {
            throw new IllegalArgumentException("Action activity cannot be added to a GAR with different plan.");
        }
        this.changeStoreActivities();
        this.notifyGar();
    }

    @Override
    public ProductionTreeNode getParent() {
        return this.parent;
    }

    @Override
    public void accept(ProductionTreeVisitor visitor, boolean childrenFirst) {
        visitor.visit(this);
    }

    @Override
    public void childChanged(ProductionTreeNode child) {
        throw new UnsupportedOperationException("ActionActivity is not supposed to have any children.");
    }

    @Override
    public void unsafeAddChild(ProductionTreeNode child) {
        throw new UnsupportedOperationException("ActionActivity is not supposed to have any children.");
    }

    @Override
    public boolean unsafeRemoveChild(ProductionTreeNode child) {
        throw new UnsupportedOperationException("ActionActivity is not supposed to have any children.");
    }

    @Override
    public Superplan getSuperplan() {
        return ProductionTreeAlgorithms.getSuperplan(this);
    }

    public GeneralizedOrderRequest getNearestGor() {
        return ProductionTreeAlgorithms.getNearestGor(this);
    }

    public GeneralizedOrderRequest getFarthestGor() {
        return ProductionTreeAlgorithms.getFarthestGor(this);
    }

    public GeneralizedActionRequest getGar() {
        return (GeneralizedActionRequest)this.getParent();
    }

    @Override
    protected void preSetPlan() {
        this.removeStoreActivitiesFromPlan();
        super.preSetPlan();
    }

    @Override
    protected void postSetPlan() {
        this.addStoreActivitiesToPlan();
        super.postSetPlan();
        this.notifyGar();
        Preconditions.checkState(this.getPlan() == null || this.getGar() == null || this.getGar().getPlan() != null, "The AA has the plan set while its parent GAR not.");
    }

    private void removeStoreActivitiesFromPlan() {
        Plan plan = this.getPlan();
        if (plan != null && this.storeActivities != null) {
            for (StoreActivity storeActivity : this.storeActivities) {
                plan.removeActivity(storeActivity);
            }
        }
    }

    private void addStoreActivitiesToPlan() {
        Plan plan = this.getPlan();
        if (plan != null && this.storeActivities != null) {
            for (StoreActivity storeActivity : this.storeActivities) {
                plan.addActivity(storeActivity);
            }
        }
    }

    @Override
    protected boolean isStoredInWorkplaceSchedule() {
        return this.getPlan() != null && !(this.getAction() instanceof CumulativeAction);
    }

    @Override
    void accept(WorkplaceActivityVisitor visitor) {
        visitor.visit(this);
    }
}

